/*
 * Decompiled with CFR 0.152.
 */
package com.novakj.simpleauth;

import com.novakj.simpleauth.AuthCommands;
import com.novakj.simpleauth.AuthHandler;
import com.novakj.simpleauth.AuthManager;
import com.novakj.simpleauth.HomeManager;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="simpleauth")
public class SimpleAuthMod {
    public static final String MODID = "simpleauth";
    public static final Logger LOGGER = LogManager.getLogger();
    private static ScheduledExecutorService scheduler;

    public SimpleAuthMod() {
        AuthManager.load();
        HomeManager.load();
        RegisterCommandsEvent.BUS.addListener(AuthCommands::register);
        PlayerEvent.PlayerLoggedInEvent.BUS.addListener(AuthHandler::onPlayerJoin);
        PlayerEvent.PlayerLoggedOutEvent.BUS.addListener(AuthHandler::onPlayerLeave);
        PlayerEvent.PlayerRespawnEvent.BUS.addListener(AuthHandler::onPlayerRespawn);
        PlayerInteractEvent.RightClickBlock.BUS.addListener(AuthHandler::onInteract);
        PlayerInteractEvent.LeftClickBlock.BUS.addListener(AuthHandler::onInteractLeft);
        PlayerInteractEvent.RightClickItem.BUS.addListener(AuthHandler::onInteractItem);
        LivingDamageEvent.BUS.addListener(AuthHandler::onDamage);
        BlockEvent.BreakEvent.BUS.addListener(AuthHandler::onBlockBreak);
        BlockEvent.EntityPlaceEvent.BUS.addListener(AuthHandler::onBlockPlace);
        ServerStartedEvent.BUS.addListener(this::onServerStarted);
        ServerStoppingEvent.BUS.addListener(this::onServerStopping);
        LOGGER.info("SimpleAuth loaded! Commands: /register <pass> <pass>, /login <pass>");
    }

    private void onServerStarted(ServerStartedEvent event) {
        AuthHandler.setServer(event.getServer());
        scheduler = Executors.newSingleThreadScheduledExecutor();
        scheduler.scheduleAtFixedRate(() -> {
            try {
                AuthHandler.checkAllPlayers(event.getServer());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
        LOGGER.info("Started auth position checker");
    }

    private void onServerStopping(ServerStoppingEvent event) {
        if (scheduler != null) {
            scheduler.shutdown();
            LOGGER.info("Stopped auth position checker");
        }
    }
}

