/*
 * Decompiled with CFR 0.152.
 */
package com.novakj.simpleauth;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.novakj.simpleauth.SimpleAuthMod;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;

public class HomeManager {
    private static final Path HOMES_FILE = Paths.get("config/simpleauth_homes.json", new String[0]);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Map<String, double[]> homes = new HashMap<String, double[]>();

    public static void load() {
        try {
            Files.createDirectories(HOMES_FILE.getParent(), new FileAttribute[0]);
            if (Files.exists(HOMES_FILE, new LinkOption[0])) {
                String json = Files.readString(HOMES_FILE);
                Map loaded = (Map)GSON.fromJson(json, new TypeToken<Map<String, double[]>>(){}.getType());
                if (loaded != null) {
                    homes = loaded;
                }
                SimpleAuthMod.LOGGER.info("Loaded {} player homes", (Object)homes.size());
            }
        }
        catch (Exception e) {
            SimpleAuthMod.LOGGER.error("Failed to load homes: {}", (Object)e.getMessage());
        }
    }

    private static void save() {
        try {
            Files.writeString(HOMES_FILE, (CharSequence)GSON.toJson(homes), new OpenOption[0]);
        }
        catch (Exception e) {
            SimpleAuthMod.LOGGER.error("Failed to save homes: {}", (Object)e.getMessage());
        }
    }

    public static boolean hasHome(String playerName) {
        return homes.containsKey(playerName.toLowerCase());
    }

    public static double[] getHome(String playerName) {
        return homes.get(playerName.toLowerCase());
    }

    public static void setHome(String playerName, double x, double y, double z) {
        homes.put(playerName.toLowerCase(), new double[]{x, y, z});
        HomeManager.save();
        SimpleAuthMod.LOGGER.info("Player {} set home at [{}, {}, {}]", (Object)playerName, (Object)x, (Object)y, (Object)z);
    }

    public static void removeHome(String playerName) {
        homes.remove(playerName.toLowerCase());
        HomeManager.save();
    }
}

