/*
 * Decompiled with CFR 0.152.
 */
package com.novakj.simpleauth;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.novakj.simpleauth.SimpleAuthMod;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AuthManager {
    private static final Path PASSWORD_FILE = Paths.get("config/simpleauth_passwords.json", new String[0]);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Map<String, String> passwords = new HashMap<String, String>();
    private static final Set<String> loggedIn = new HashSet<String>();

    public static void load() {
        try {
            Files.createDirectories(PASSWORD_FILE.getParent(), new FileAttribute[0]);
            if (Files.exists(PASSWORD_FILE, new LinkOption[0])) {
                String json = Files.readString(PASSWORD_FILE);
                Map loaded = (Map)GSON.fromJson(json, new TypeToken<Map<String, String>>(){}.getType());
                if (loaded != null) {
                    passwords = loaded;
                }
                SimpleAuthMod.LOGGER.info("Loaded {} registered players", (Object)passwords.size());
            }
        }
        catch (Exception e) {
            SimpleAuthMod.LOGGER.error("Failed to load passwords: {}", (Object)e.getMessage());
        }
    }

    private static void save() {
        try {
            Files.writeString(PASSWORD_FILE, (CharSequence)GSON.toJson(passwords), new OpenOption[0]);
        }
        catch (Exception e) {
            SimpleAuthMod.LOGGER.error("Failed to save passwords: {}", (Object)e.getMessage());
        }
    }

    public static boolean isRegistered(String playerName) {
        return passwords.containsKey(playerName.toLowerCase());
    }

    public static boolean isLoggedIn(String playerName) {
        return loggedIn.contains(playerName.toLowerCase());
    }

    public static boolean register(String playerName, String password) {
        String name = playerName.toLowerCase();
        if (passwords.containsKey(name)) {
            return false;
        }
        passwords.put(name, AuthManager.hash(password));
        loggedIn.add(name);
        AuthManager.save();
        SimpleAuthMod.LOGGER.info("Player {} registered", (Object)playerName);
        return true;
    }

    public static boolean login(String playerName, String password) {
        String name = playerName.toLowerCase();
        String stored = passwords.get(name);
        if (stored == null) {
            return false;
        }
        if (stored.equals(AuthManager.hash(password))) {
            loggedIn.add(name);
            SimpleAuthMod.LOGGER.info("Player {} logged in", (Object)playerName);
            return true;
        }
        return false;
    }

    public static void logout(String playerName) {
        loggedIn.remove(playerName.toLowerCase());
    }

    private static String hash(String password) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hash = md.digest(password.getBytes());
            StringBuilder sb = new StringBuilder();
            for (byte b : hash) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (Exception e) {
            return password;
        }
    }
}

