/*
 * Decompiled with CFR 0.152.
 */
package com.novakj.simpleauth;

import com.novakj.simpleauth.AuthManager;
import com.novakj.simpleauth.SimpleAuthMod;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;

public class AuthHandler {
    private static Method cachedSendMethod = null;
    private static Field cachedConnectionField = null;
    private static Method cachedLiteralMethod = null;
    public static final double[] SPAWN_POINT = new double[]{0.5, 80.0, 0.5};
    public static final int SPAWN_PROTECTION_RADIUS = 48;
    private static final Map<String, double[]> originalPositions = new HashMap<String, double[]>();
    private static final Map<String, Boolean> frozenPlayers = new HashMap<String, Boolean>();
    private static final Map<String, Integer> joinDelay = new HashMap<String, Integer>();
    private static final Map<String, Boolean> newRegistrations = new HashMap<String, Boolean>();
    private static final Map<String, Integer> pendingRespawnTeleport = new HashMap<String, Integer>();
    private static MinecraftServer serverInstance = null;
    private static int tickCounter = 0;

    public static void setServer(MinecraftServer server) {
        serverInstance = server;
    }

    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        String playerName = AuthHandler.getPlayerName(player2);
        String nameLower = playerName.toLowerCase();
        boolean registered = AuthManager.isRegistered(playerName);
        joinDelay.put(nameLower, 0);
        frozenPlayers.put(nameLower, true);
        AuthHandler.setGameMode(player2, 3);
        if (registered) {
            AuthHandler.sendActionBar(player2, "\u00a7cFROZEN! \u00a7eUse: \u00a7f/login <password>");
        } else {
            AuthHandler.sendActionBar(player2, "\u00a7cFROZEN! \u00a7eUse: \u00a7f/register <password> <password>");
        }
        SimpleAuthMod.LOGGER.info("Player {} joined, frozen in SPECTATOR until auth", (Object)playerName);
    }

    public static void checkAllPlayers(MinecraftServer server) {
        ++tickCounter;
        List<ServerPlayer> players = AuthHandler.getOnlinePlayers(server);
        for (ServerPlayer player : players) {
            double[] origPos;
            int delay;
            String playerName = AuthHandler.getPlayerName(player);
            String nameLower = playerName.toLowerCase();
            if (pendingRespawnTeleport.containsKey(nameLower)) {
                delay = pendingRespawnTeleport.get(nameLower);
                if (delay >= 5) {
                    AuthHandler.teleportPlayerOnServerThread(player, SPAWN_POINT[0], SPAWN_POINT[1], SPAWN_POINT[2]);
                    pendingRespawnTeleport.remove(nameLower);
                    SimpleAuthMod.LOGGER.info("Respawn teleported {} to spawn [{}, {}, {}]", (Object)playerName, (Object)SPAWN_POINT[0], (Object)SPAWN_POINT[1], (Object)SPAWN_POINT[2]);
                } else {
                    pendingRespawnTeleport.put(nameLower, delay + 1);
                }
            }
            if (AuthManager.isLoggedIn(playerName)) {
                if (!frozenPlayers.containsKey(nameLower)) continue;
                if (newRegistrations.containsKey(nameLower)) {
                    AuthHandler.teleportPlayerOnServerThread(player, SPAWN_POINT[0], SPAWN_POINT[1], SPAWN_POINT[2]);
                    SimpleAuthMod.LOGGER.info("Teleported NEW player {} to spawn [{}, {}, {}]", (Object)playerName, (Object)SPAWN_POINT[0], (Object)SPAWN_POINT[1], (Object)SPAWN_POINT[2]);
                    newRegistrations.remove(nameLower);
                } else {
                    double[] origPos2 = originalPositions.get(nameLower);
                    if (origPos2 != null) {
                        AuthHandler.teleportPlayerOnServerThread(player, origPos2[0], origPos2[1], origPos2[2]);
                        SimpleAuthMod.LOGGER.info("Teleported {} back to original position [{}, {}, {}]", (Object)playerName, (Object)origPos2[0], (Object)origPos2[1], (Object)origPos2[2]);
                    }
                }
                AuthHandler.setGameMode(player, 0);
                frozenPlayers.remove(nameLower);
                originalPositions.remove(nameLower);
                joinDelay.remove(nameLower);
                SimpleAuthMod.LOGGER.info("Player {} authenticated, switched to SURVIVAL", (Object)playerName);
                continue;
            }
            if (joinDelay.containsKey(nameLower)) {
                delay = joinDelay.get(nameLower);
                if (delay < 10) {
                    joinDelay.put(nameLower, delay + 1);
                    AuthHandler.setGameMode(player, 3);
                    continue;
                }
                double[] pos = AuthHandler.getPlayerPosition(player);
                originalPositions.put(nameLower, pos);
                joinDelay.remove(nameLower);
                SimpleAuthMod.LOGGER.info("Captured spawn position for {}: [{}, {}, {}]", (Object)playerName, (Object)pos[0], (Object)pos[1], (Object)pos[2]);
            }
            if ((origPos = originalPositions.get(nameLower)) != null) {
                AuthHandler.teleportPlayer(player, origPos[0], origPos[1], origPos[2]);
            }
            AuthHandler.setGameMode(player, 3);
            if (tickCounter % 20 != 0) continue;
            boolean registered = AuthManager.isRegistered(playerName);
            if (registered) {
                AuthHandler.sendActionBar(player, "\u00a7cFROZEN! \u00a7eUse: \u00a7f/login <password>");
                continue;
            }
            AuthHandler.sendActionBar(player, "\u00a7cFROZEN! \u00a7eUse: \u00a7f/register <password> <password>");
        }
    }

    private static List<ServerPlayer> getOnlinePlayers(MinecraftServer server) {
        ArrayList<ServerPlayer> result = new ArrayList<ServerPlayer>();
        try {
            for (Method m : server.getClass().getMethods()) {
                Object playerList;
                if (!m.getName().contains("PlayerList") || m.getParameterCount() != 0 || (playerList = m.invoke((Object)server, new Object[0])) == null) continue;
                for (Method pm : playerList.getClass().getMethods()) {
                    Object players;
                    if (!pm.getName().equals("getPlayers") || pm.getParameterCount() != 0 || !((players = pm.invoke(playerList, new Object[0])) instanceof List)) continue;
                    for (Object p : (List)players) {
                        if (!(p instanceof ServerPlayer)) continue;
                        ServerPlayer sp = (ServerPlayer)p;
                        result.add(sp);
                    }
                    return result;
                }
            }
        }
        catch (Throwable e) {
            SimpleAuthMod.LOGGER.debug("getOnlinePlayers failed: {}", (Object)e.getMessage());
        }
        return result;
    }

    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        String playerName = AuthHandler.getPlayerName(player2);
        String nameLower = playerName.toLowerCase();
        AuthManager.logout(playerName);
        frozenPlayers.remove(nameLower);
        originalPositions.remove(nameLower);
        joinDelay.remove(nameLower);
        newRegistrations.remove(nameLower);
        pendingRespawnTeleport.remove(nameLower);
    }

    public static void onPlayerAuthenticated(String playerName) {
        SimpleAuthMod.LOGGER.info("Player {} logged in", (Object)playerName);
    }

    public static void onNewRegistration(String playerName) {
        String nameLower = playerName.toLowerCase();
        newRegistrations.put(nameLower, true);
        SimpleAuthMod.LOGGER.info("Player {} registered as NEW - will spawn at world spawn", (Object)playerName);
    }

    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        String playerName = AuthHandler.getPlayerName(player2);
        String nameLower = playerName.toLowerCase();
        if (!AuthManager.isLoggedIn(playerName)) {
            return;
        }
        pendingRespawnTeleport.put(nameLower, 0);
        SimpleAuthMod.LOGGER.info("Player {} respawned, queued for spawn teleport", (Object)playerName);
    }

    public static void onInteract(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!AuthManager.isLoggedIn(AuthHandler.getPlayerName(player2))) {
            AuthHandler.cancelEvent(event);
        }
    }

    public static void onInteractLeft(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!AuthManager.isLoggedIn(AuthHandler.getPlayerName(player2))) {
            AuthHandler.cancelEvent(event);
        }
    }

    public static void onInteractItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!AuthManager.isLoggedIn(AuthHandler.getPlayerName(player2))) {
            AuthHandler.cancelEvent(event);
        }
    }

    public static void onDamage(LivingDamageEvent event) {
        ServerPlayer player;
        LivingEntity entity = event.getEntity();
        if (entity instanceof ServerPlayer && !AuthManager.isLoggedIn(AuthHandler.getPlayerName(player = (ServerPlayer)entity))) {
            AuthHandler.cancelEvent(event);
            return;
        }
        try {
            ServerPlayer attackerPlayer;
            Field causingField = event.getSource().getClass().getDeclaredField("causingEntity");
            causingField.setAccessible(true);
            Object attacker = causingField.get(event.getSource());
            if (attacker instanceof ServerPlayer && !AuthManager.isLoggedIn(AuthHandler.getPlayerName(attackerPlayer = (ServerPlayer)attacker))) {
                AuthHandler.cancelEvent(event);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        BlockPos pos = event.getPos();
        if (!AuthHandler.isInSpawnZone(pos.m_123341_(), pos.m_123343_())) {
            return;
        }
        if (AuthHandler.isCreativeMode(player2)) {
            return;
        }
        AuthHandler.cancelEvent(event);
        AuthHandler.sendActionBar(player2, "\u00a7cSpawn protected! \u00a7eCreative mode required to build here.");
    }

    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        BlockPos pos = event.getPos();
        if (!AuthHandler.isInSpawnZone(pos.m_123341_(), pos.m_123343_())) {
            return;
        }
        if (AuthHandler.isCreativeMode(player)) {
            return;
        }
        AuthHandler.cancelEvent(event);
        AuthHandler.sendActionBar(player, "\u00a7cSpawn protected! \u00a7eCreative mode required to build here.");
    }

    private static boolean isInSpawnZone(int x, int z) {
        return Math.abs(x) <= 48 && Math.abs(z) <= 48;
    }

    private static boolean isCreativeMode(ServerPlayer player) {
        try {
            for (Method m : player.getClass().getMethods()) {
                Object gameModeObj;
                if (!m.getName().contains("gameMode") || m.getParameterCount() != 0 || (gameModeObj = m.invoke((Object)player, new Object[0])) == null) continue;
                for (Method gm : gameModeObj.getClass().getMethods()) {
                    Object gameType;
                    if (!gm.getName().contains("GameType") || gm.getParameterCount() != 0 || (gameType = gm.invoke(gameModeObj, new Object[0])) == null) continue;
                    String typeName = gameType.toString().toUpperCase();
                    return typeName.contains("CREATIVE");
                }
            }
            for (Method m : player.getClass().getMethods()) {
                if (!m.getName().equals("isCreative") || m.getParameterCount() != 0) continue;
                return (Boolean)m.invoke((Object)player, new Object[0]);
            }
        }
        catch (Exception e) {
            SimpleAuthMod.LOGGER.debug("isCreativeMode check failed: {}", (Object)e.getMessage());
        }
        return false;
    }

    private static void cancelEvent(Object event) {
        try {
            for (Method m : event.getClass().getMethods()) {
                if (!m.getName().contains("setCanceled") && !m.getName().contains("setCancelled") || m.getParameterCount() != 1 || m.getParameterTypes()[0] != Boolean.TYPE) continue;
                m.invoke(event, true);
                return;
            }
        }
        catch (Exception e) {
            SimpleAuthMod.LOGGER.debug("cancelEvent failed: {}", (Object)e.getMessage());
        }
    }

    private static String getPlayerName(ServerPlayer player) {
        try {
            for (Method m : player.getClass().getMethods()) {
                if (!m.getName().contains("GameProfile") || m.getParameterCount() != 0) continue;
                Object profile = m.invoke((Object)player, new Object[0]);
                for (Method pm : profile.getClass().getMethods()) {
                    if (!pm.getName().equals("getName") || pm.getParameterCount() != 0) continue;
                    return (String)pm.invoke(profile, new Object[0]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            for (Method m : player.getClass().getMethods()) {
                if (!m.getName().equals("getName") || m.getParameterCount() != 0) continue;
                Object result = m.invoke((Object)player, new Object[0]);
                if (result instanceof Component) {
                    Component comp = (Component)result;
                    return comp.getString();
                }
                return result.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "Unknown";
    }

    private static void setGameMode(ServerPlayer player, int mode) {
        try {
            for (Method m : player.getClass().getMethods()) {
                ?[] constants;
                Class<?> paramType;
                if (!m.getName().contains("setGameMode") || m.getParameterCount() != 1 || !(paramType = m.getParameterTypes()[0]).isEnum() || (constants = paramType.getEnumConstants()).length <= mode) continue;
                m.invoke((Object)player, constants[mode]);
                return;
            }
        }
        catch (Exception e) {
            SimpleAuthMod.LOGGER.debug("setGameMode failed: {}", (Object)e.getMessage());
        }
    }

    private static double[] getPlayerPosition(ServerPlayer player) {
        try {
            double x = 0.0;
            double y = 64.0;
            double z = 0.0;
            for (Method m : player.getClass().getMethods()) {
                if (m.getParameterCount() != 0 || m.getReturnType() != Double.TYPE) continue;
                String name = m.getName().toLowerCase();
                if (name.equals("getx") || name.equals("x")) {
                    x = (Double)m.invoke((Object)player, new Object[0]);
                    continue;
                }
                if (name.equals("gety") || name.equals("y")) {
                    y = (Double)m.invoke((Object)player, new Object[0]);
                    continue;
                }
                if (!name.equals("getz") && !name.equals("z")) continue;
                z = (Double)m.invoke((Object)player, new Object[0]);
            }
            return new double[]{x, y, z};
        }
        catch (Exception e) {
            SimpleAuthMod.LOGGER.debug("getPlayerPosition failed: {}", (Object)e.getMessage());
            return new double[]{0.0, 64.0, 0.0};
        }
    }

    private static void teleportPlayer(ServerPlayer player, double x, double y, double z) {
        try {
            Class<?>[] params;
            for (Method m : player.getClass().getMethods()) {
                if (!m.getName().equals("teleportTo") || m.getParameterCount() != 5 || (params = m.getParameterTypes())[0] != Double.TYPE || params[1] != Double.TYPE || params[2] != Double.TYPE) continue;
                m.invoke((Object)player, x, y, z, Float.valueOf(player.m_146908_()), Float.valueOf(player.m_146909_()));
                return;
            }
            for (Method m : player.getClass().getMethods()) {
                if (!m.getName().equals("moveTo") || m.getParameterCount() != 3 || (params = m.getParameterTypes())[0] != Double.TYPE) continue;
                m.invoke((Object)player, x, y, z);
                return;
            }
            for (Method m : player.getClass().getMethods()) {
                if (!m.getName().equals("setPos") || m.getParameterCount() != 3) continue;
                m.invoke((Object)player, x, y, z);
                return;
            }
        }
        catch (Exception e) {
            SimpleAuthMod.LOGGER.debug("teleportPlayer failed: {}", (Object)e.getMessage());
        }
    }

    private static void teleportPlayerOnServerThread(ServerPlayer player, double x, double y, double z) {
        if (serverInstance != null) {
            String playerName = AuthHandler.getPlayerName(player);
            String command = String.format("tp %s %.1f %.1f %.1f", playerName, x, y, z);
            AuthHandler.executeCommand(command);
        } else {
            AuthHandler.teleportPlayer(player, x, y, z);
        }
    }

    private static void executeCommand(String command) {
        if (serverInstance == null) {
            return;
        }
        try {
            Object commands = null;
            for (Method m : serverInstance.getClass().getMethods()) {
                if (!m.getName().equals("getCommands") || m.getParameterCount() != 0) continue;
                commands = m.invoke((Object)serverInstance, new Object[0]);
                break;
            }
            if (commands == null) {
                SimpleAuthMod.LOGGER.warn("Could not find getCommands method");
                return;
            }
            Object sourceStack = null;
            for (Method m : serverInstance.getClass().getMethods()) {
                if (!m.getName().contains("CommandSourceStack") || m.getParameterCount() != 0) continue;
                sourceStack = m.invoke((Object)serverInstance, new Object[0]);
                break;
            }
            if (sourceStack == null) {
                SimpleAuthMod.LOGGER.warn("Could not find createCommandSourceStack method");
                return;
            }
            for (Method m : commands.getClass().getMethods()) {
                if (!m.getName().equals("performPrefixedCommand") && !m.getName().equals("performCommand") || m.getParameterCount() != 2) continue;
                m.invoke(commands, sourceStack, command);
                SimpleAuthMod.LOGGER.debug("Executed command: {}", (Object)command);
                return;
            }
            SimpleAuthMod.LOGGER.warn("Could not find performCommand method");
        }
        catch (Exception e) {
            SimpleAuthMod.LOGGER.error("executeCommand failed: {}", (Object)e.getMessage());
        }
    }

    private static void sendActionBar(ServerPlayer player, String message) {
        try {
            Object component;
            if (cachedConnectionField == null) {
                AuthHandler.initReflection(player);
            }
            if ((component = AuthHandler.createComponent(message)) == null || cachedConnectionField == null || cachedSendMethod == null) {
                return;
            }
            Object connection = cachedConnectionField.get(player);
            if (connection != null) {
                Class<?> packetClass = Class.forName("net.minecraft.network.protocol.game.ClientboundSystemChatPacket");
                for (Constructor<?> ctor : packetClass.getConstructors()) {
                    if (ctor.getParameterCount() != 2) continue;
                    Object packet = ctor.newInstance(component, true);
                    cachedSendMethod.invoke(connection, packet);
                    return;
                }
            }
        }
        catch (Exception e) {
            SimpleAuthMod.LOGGER.debug("sendActionBar failed: {}", (Object)e.getMessage());
        }
    }

    private static void initReflection(ServerPlayer player) {
        try {
            for (Field f : ServerPlayer.class.getDeclaredFields()) {
                f.setAccessible(true);
                Object obj = f.get(player);
                if (obj == null) continue;
                for (Method m : obj.getClass().getMethods()) {
                    Class<?> paramType;
                    if (!m.getName().equals("send") || m.getParameterCount() != 1 || !Packet.class.isAssignableFrom(paramType = m.getParameterTypes()[0])) continue;
                    cachedConnectionField = f;
                    cachedSendMethod = m;
                    return;
                }
            }
        }
        catch (Exception e) {
            SimpleAuthMod.LOGGER.error("Reflection init failed: {}", (Object)e.getMessage());
        }
    }

    private static Object createComponent(String text) {
        if (cachedLiteralMethod != null) {
            try {
                return cachedLiteralMethod.invoke(null, text);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            for (Method m : Component.class.getDeclaredMethods()) {
                if (!Modifier.isStatic(m.getModifiers()) || m.getParameterCount() != 1 || m.getParameterTypes()[0] != String.class || !Component.class.isAssignableFrom(m.getReturnType())) continue;
                m.setAccessible(true);
                Object result = m.invoke(null, text);
                if (result == null) continue;
                cachedLiteralMethod = m;
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

