/*
 * Decompiled with CFR 0.152.
 */
package com.novakj.simpleauth;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.novakj.simpleauth.AuthHandler;
import com.novakj.simpleauth.AuthManager;
import com.novakj.simpleauth.HomeManager;
import com.novakj.simpleauth.SimpleAuthMod;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;

public class AuthCommands {
    private static Method cachedSendMethod = null;
    private static Field cachedConnectionField = null;
    private static Method cachedLiteralMethod = null;
    private static double[] SPAWN_POINT = AuthHandler.SPAWN_POINT;

    public static void register(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"register").then(RequiredArgumentBuilder.argument((String)"password", (ArgumentType)StringArgumentType.string()).then(RequiredArgumentBuilder.argument((String)"confirm", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            try {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                ServerPlayer player = AuthCommands.getPlayerFromSource(source);
                if (player == null) {
                    return 0;
                }
                String playerName = AuthCommands.getPlayerName(player);
                String password = StringArgumentType.getString((CommandContext)ctx, (String)"password");
                String confirm = StringArgumentType.getString((CommandContext)ctx, (String)"confirm");
                if (AuthManager.isRegistered(playerName)) {
                    AuthCommands.sendChatMessage(player, "\u00a7cYou are already registered! Use /login <password>");
                    return 0;
                }
                if (!password.equals(confirm)) {
                    AuthCommands.sendChatMessage(player, "\u00a7cPasswords do not match!");
                    return 0;
                }
                if (password.length() < 4) {
                    AuthCommands.sendChatMessage(player, "\u00a7cPassword must be at least 4 characters!");
                    return 0;
                }
                if (AuthManager.register(playerName, password)) {
                    AuthCommands.sendChatMessage(player, "\u00a7aSuccessfully registered! You are now logged in.");
                    AuthHandler.onNewRegistration(playerName);
                    AuthHandler.onPlayerAuthenticated(playerName);
                    AuthCommands.setGameMode(player, 0);
                    return 1;
                }
                AuthCommands.sendChatMessage(player, "\u00a7cRegistration failed!");
                return 0;
            }
            catch (Throwable e) {
                SimpleAuthMod.LOGGER.error("Register command error: {}", (Object)e.toString());
                e.printStackTrace();
                return 0;
            }
        }))));
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"login").then(RequiredArgumentBuilder.argument((String)"password", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            try {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                ServerPlayer player = AuthCommands.getPlayerFromSource(source);
                if (player == null) {
                    return 0;
                }
                String playerName = AuthCommands.getPlayerName(player);
                String password = StringArgumentType.getString((CommandContext)ctx, (String)"password");
                if (!AuthManager.isRegistered(playerName)) {
                    AuthCommands.sendChatMessage(player, "\u00a7cYou are not registered! Use /register <password> <password>");
                    return 0;
                }
                if (AuthManager.isLoggedIn(playerName)) {
                    AuthCommands.sendChatMessage(player, "\u00a7cYou are already logged in!");
                    return 0;
                }
                if (AuthManager.login(playerName, password)) {
                    AuthCommands.sendChatMessage(player, "\u00a7aSuccessfully logged in!");
                    AuthHandler.onPlayerAuthenticated(playerName);
                    AuthCommands.setGameMode(player, 0);
                    return 1;
                }
                AuthCommands.sendChatMessage(player, "\u00a7cWrong password!");
                return 0;
            }
            catch (Throwable e) {
                SimpleAuthMod.LOGGER.error("Login command error: {}", (Object)e.toString());
                e.printStackTrace();
                return 0;
            }
        })));
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"sethome").executes(ctx -> {
            try {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                ServerPlayer player = AuthCommands.getPlayerFromSource(source);
                if (player == null) {
                    return 0;
                }
                String playerName = AuthCommands.getPlayerName(player);
                if (!AuthManager.isLoggedIn(playerName)) {
                    AuthCommands.sendChatMessage(player, "\u00a7cYou must be logged in to set home!");
                    return 0;
                }
                double[] pos = AuthCommands.getPlayerPosition(player);
                HomeManager.setHome(playerName, pos[0], pos[1], pos[2]);
                AuthCommands.sendChatMessage(player, "\u00a7aHome set at [" + (int)pos[0] + ", " + (int)pos[1] + ", " + (int)pos[2] + "]");
                return 1;
            }
            catch (Throwable e) {
                SimpleAuthMod.LOGGER.error("Sethome command error: {}", (Object)e.toString());
                return 0;
            }
        }));
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"home").executes(ctx -> {
            try {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                ServerPlayer player = AuthCommands.getPlayerFromSource(source);
                if (player == null) {
                    return 0;
                }
                String playerName = AuthCommands.getPlayerName(player);
                if (!AuthManager.isLoggedIn(playerName)) {
                    AuthCommands.sendChatMessage(player, "\u00a7cYou must be logged in to teleport home!");
                    return 0;
                }
                if (!HomeManager.hasHome(playerName)) {
                    AuthCommands.sendChatMessage(player, "\u00a7cYou don't have a home set! Use /sethome first.");
                    return 0;
                }
                double[] home = HomeManager.getHome(playerName);
                AuthCommands.teleportPlayer(player, home[0], home[1], home[2]);
                AuthCommands.sendChatMessage(player, "\u00a7aTeleported to home!");
                return 1;
            }
            catch (Throwable e) {
                SimpleAuthMod.LOGGER.error("Home command error: {}", (Object)e.toString());
                return 0;
            }
        }));
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"spawn").executes(ctx -> {
            try {
                CommandSourceStack source = (CommandSourceStack)ctx.getSource();
                ServerPlayer player = AuthCommands.getPlayerFromSource(source);
                if (player == null) {
                    return 0;
                }
                String playerName = AuthCommands.getPlayerName(player);
                if (!AuthManager.isLoggedIn(playerName)) {
                    AuthCommands.sendChatMessage(player, "\u00a7cYou must be logged in to teleport to spawn!");
                    return 0;
                }
                AuthCommands.teleportPlayer(player, SPAWN_POINT[0], SPAWN_POINT[1], SPAWN_POINT[2]);
                AuthCommands.sendChatMessage(player, "\u00a7aTeleported to spawn!");
                return 1;
            }
            catch (Throwable e) {
                SimpleAuthMod.LOGGER.error("Spawn command error: {}", (Object)e.toString());
                return 0;
            }
        }));
        SimpleAuthMod.LOGGER.info("Registered /register, /login, /sethome, /home, /spawn commands");
    }

    private static double[] getPlayerPosition(ServerPlayer player) {
        try {
            double x = 0.0;
            double y = 64.0;
            double z = 0.0;
            for (Method m : player.getClass().getMethods()) {
                if (m.getParameterCount() != 0 || m.getReturnType() != Double.TYPE) continue;
                String name = m.getName().toLowerCase();
                if (name.equals("getx") || name.equals("x")) {
                    x = (Double)m.invoke((Object)player, new Object[0]);
                    continue;
                }
                if (name.equals("gety") || name.equals("y")) {
                    y = (Double)m.invoke((Object)player, new Object[0]);
                    continue;
                }
                if (!name.equals("getz") && !name.equals("z")) continue;
                z = (Double)m.invoke((Object)player, new Object[0]);
            }
            return new double[]{x, y, z};
        }
        catch (Exception e) {
            return new double[]{0.0, 64.0, 0.0};
        }
    }

    private static void teleportPlayer(ServerPlayer player, double x, double y, double z) {
        try {
            Class<?>[] params;
            for (Method m : player.getClass().getMethods()) {
                if (!m.getName().equals("teleportTo") || m.getParameterCount() != 5 || (params = m.getParameterTypes())[0] != Double.TYPE || params[1] != Double.TYPE || params[2] != Double.TYPE) continue;
                m.invoke((Object)player, x, y, z, Float.valueOf(player.m_146908_()), Float.valueOf(player.m_146909_()));
                return;
            }
            for (Method m : player.getClass().getMethods()) {
                if (!m.getName().equals("moveTo") || m.getParameterCount() != 3 || (params = m.getParameterTypes())[0] != Double.TYPE) continue;
                m.invoke((Object)player, x, y, z);
                return;
            }
            for (Method m : player.getClass().getMethods()) {
                if (!m.getName().equals("setPos") || m.getParameterCount() != 3) continue;
                m.invoke((Object)player, x, y, z);
                return;
            }
        }
        catch (Exception e) {
            SimpleAuthMod.LOGGER.debug("teleportPlayer failed: {}", (Object)e.getMessage());
        }
    }

    private static ServerPlayer getPlayerFromSource(CommandSourceStack source) {
        try {
            Object result;
            for (Method m : source.getClass().getMethods()) {
                if (m.getParameterCount() != 0 || m.getReturnType() != ServerPlayer.class && !m.getName().contains("Entity") && !m.getName().contains("Player") || !((result = m.invoke((Object)source, new Object[0])) instanceof ServerPlayer)) continue;
                ServerPlayer sp = (ServerPlayer)result;
                return sp;
            }
            for (Method m : source.getClass().getMethods()) {
                if (m.getParameterCount() != 0 || !m.getName().toLowerCase().contains("player")) continue;
                try {
                    result = m.invoke((Object)source, new Object[0]);
                    if (!(result instanceof ServerPlayer)) continue;
                    ServerPlayer sp = (ServerPlayer)result;
                    return sp;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable e) {
            SimpleAuthMod.LOGGER.error("getPlayerFromSource failed: {}", (Object)e.toString());
        }
        return null;
    }

    private static String getPlayerName(ServerPlayer player) {
        try {
            for (Method m : player.getClass().getMethods()) {
                if (!m.getName().contains("GameProfile") || m.getParameterCount() != 0) continue;
                Object profile = m.invoke((Object)player, new Object[0]);
                for (Method pm : profile.getClass().getMethods()) {
                    if (!pm.getName().equals("getName") || pm.getParameterCount() != 0) continue;
                    return (String)pm.invoke(profile, new Object[0]);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            for (Method m : player.getClass().getMethods()) {
                if (!m.getName().equals("getName") || m.getParameterCount() != 0) continue;
                Object result = m.invoke((Object)player, new Object[0]);
                if (result instanceof Component) {
                    Component comp = (Component)result;
                    return comp.getString();
                }
                return result.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "Unknown";
    }

    private static void setGameMode(ServerPlayer player, int mode) {
        try {
            for (Method m : player.getClass().getMethods()) {
                ?[] constants;
                Class<?> paramType;
                if (!m.getName().contains("setGameMode") || m.getParameterCount() != 1 || !(paramType = m.getParameterTypes()[0]).isEnum() || (constants = paramType.getEnumConstants()).length <= mode) continue;
                m.invoke((Object)player, constants[mode]);
                SimpleAuthMod.LOGGER.info("Set gamemode to {} for player", (Object)mode);
                return;
            }
            SimpleAuthMod.LOGGER.warn("Could not find setGameMode method");
        }
        catch (Throwable e) {
            SimpleAuthMod.LOGGER.error("setGameMode failed: {}", (Object)e.toString());
        }
    }

    private static void sendChatMessage(ServerPlayer player, String message) {
        try {
            Object component;
            if (cachedConnectionField == null) {
                AuthCommands.initReflection(player);
            }
            if ((component = AuthCommands.createComponent(message)) == null) {
                SimpleAuthMod.LOGGER.warn("Could not create component");
                return;
            }
            if (cachedConnectionField == null || cachedSendMethod == null) {
                SimpleAuthMod.LOGGER.warn("Connection not initialized");
                return;
            }
            Object connection = cachedConnectionField.get(player);
            if (connection == null) {
                SimpleAuthMod.LOGGER.warn("Connection is null");
                return;
            }
            try {
                Class<?> packetClass = Class.forName("net.minecraft.network.protocol.game.ClientboundSystemChatPacket");
                for (Constructor<?> ctor : packetClass.getConstructors()) {
                    if (ctor.getParameterCount() != 2) continue;
                    Object packet = ctor.newInstance(component, false);
                    cachedSendMethod.invoke(connection, packet);
                    return;
                }
            }
            catch (Throwable e) {
                SimpleAuthMod.LOGGER.debug("SystemChat packet failed: {}", (Object)e.getMessage());
            }
        }
        catch (Throwable e) {
            SimpleAuthMod.LOGGER.error("sendChatMessage failed: {}", (Object)e.toString());
        }
    }

    private static void initReflection(ServerPlayer player) {
        try {
            for (Field f : ServerPlayer.class.getDeclaredFields()) {
                f.setAccessible(true);
                Object obj = f.get(player);
                if (obj == null) continue;
                for (Method m : obj.getClass().getMethods()) {
                    Class<?> paramType;
                    if (!m.getName().equals("send") || m.getParameterCount() != 1 || !Packet.class.isAssignableFrom(paramType = m.getParameterTypes()[0])) continue;
                    cachedConnectionField = f;
                    cachedSendMethod = m;
                    SimpleAuthMod.LOGGER.info("Found connection: {} with send method", (Object)f.getName());
                    return;
                }
            }
            SimpleAuthMod.LOGGER.warn("Could not find connection.send method");
        }
        catch (Throwable e) {
            SimpleAuthMod.LOGGER.error("Reflection init failed: {}", (Object)e.toString());
        }
    }

    private static Object createComponent(String text) {
        if (cachedLiteralMethod != null) {
            try {
                return cachedLiteralMethod.invoke(null, text);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            for (Method m : Component.class.getDeclaredMethods()) {
                if (!Modifier.isStatic(m.getModifiers()) || m.getParameterCount() != 1 || m.getParameterTypes()[0] != String.class || !Component.class.isAssignableFrom(m.getReturnType())) continue;
                m.setAccessible(true);
                Object result = m.invoke(null, text);
                if (result == null) continue;
                cachedLiteralMethod = m;
                return result;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

